<?php

	class mysql_paged_result
	{
		var $dbconn;
		var $query;
		var $sql;
		var $page_size;
		var $page;
		var $total_pages;
		var $total_rows;
		var $row_start;
		var $row_end;
		var $debug;
		var $error;
		var $exe_time;
		
		// constructor 
		function mysql_paged_result( $query, $dbconn )
		{
			$query = trim($query);
			if(substr($query,-1,0)==';')
				$query = substr($query,0,strlen($query)-1);
			
			$this->query       = $query;
			$ptrns = array("\n","\r","\t");
			$this->sql = str_replace($ptrns,' ',$this->query); // remove a few chrs so our regex operations are more reliable
			$this->sql = preg_replace( "/LIMIT .*$/is", '', $this->sql, 1 ); // strip limit statement if present

			$this->dbconn      = $dbconn;
			$this->debug       = array();
			$this->error       = array();
			
			// a few defaults
			$this->page_size   = 0; // default do not page query
			$this->page        = 1; 
			$this->total_pages = 0;
			$this->total_rows  = 0;
			$this->row_start   = 0;
			$this->row_end     = 0;
		}

		function count_rows()
		{
			// count all rows that match our WHERE statement
			$ptrn     = "/^SELECT .+ FROM/is";
			$replace  = " SELECT 1 FROM ";
			$sqlcount = preg_replace( $ptrn, $replace, $this->sql, 1 );
			// we don't need to order the results so kill it to speed query time
			$ptrn     = "/ORDER BY .+$/is";
			$sqlcount = preg_replace( $ptrn, '', $sqlcount, 1 );	
			$result   = mysql_query($sqlcount,$this->dbconn) or $this->debug[] = 'count_rows(): '.mysql_error().' : '. $sqlcount;
			if($result)
			{
				$total = mysql_num_rows($result);
				mysql_free_result($result); // incase we have a very large result set.
				return $total;
			}
			$this->debug[] = "count_rows(): $sqlcount";
			$this->error[] = "Total rows cannot be found.";
			return false;
		}

		function fetch_page($page=1)
		{
			$ptrn = "/^SELECT (.+) FROM /is";
			if( preg_match($ptrn,$this->sql) )
			{
				$start=microtime();
				$this->total_rows = $this->count_rows();
				if( $this->total_rows !== false )
				{
					if($this->page_size==0) // unlimited
					{
						$this->total_pages = 1;
						$this->row_start = 0;
						$querysql = $this->sql;
					}
					else
					{
						$this->total_pages = ceil($this->total_rows/$this->page_size);
						$this->page = (is_numeric($page))? intval($page) : 1 ;
						if ($this->page < 1){ $this->page = 1; } 
						if ($this->page > $this->total_pages){ $this->page = $this->total_pages; }
						$offset = ($this->page-1) * $this->page_size;
						$offset = ($offset<0)? 0 : $offset ;
						$this->row_start = ($this->total_rows==0)? 0 : $offset+1;
						
						// add limit to sql
						$querysql = $this->sql.' LIMIT '.$offset.', '.$this->page_size.' '; // add limit statement
					}
					
					// run query
					$result = mysql_query($querysql,$this->dbconn) or $this->debug[] = mysql_error().' : '. $querysql;
					$this->row_end = $offset + mysql_num_rows($result);
					$this->exe_time = (microtime()-$start);
					return $result; // return by reference or value with resource?? Someone smart please??
				}
			}
			$this->debug[] = $this->sql;
			$this->error[] = "SQL statement is not a valid SELECT query.";
			return false;
		}
		
		function fetch_stats()
		{
			$stats = array();
			$stats['page'] = $this->page;
			$stats['total_pages'] = $this->total_pages;
			$stats['total_rows'] = $this->total_rows;
			$stats['row_start'] = $this->row_start;
			$stats['row_end'] = $this->row_end;
			$stats['exe_time'] = $this->exe_time;
			return $stats;
		}
		
		function debug()
		{
			$this->debug[] = "Original query: ".$this->query;
			$this->debug[] = "Stripped query: ".$this->sql;
			$this->debug[] = "Execution: ".$this->exe_time;
			return $this->debug;
		}
		
		function error()
		{
			return $this->error;
		}
	}
	
	// example
	/*
	$qp = new mysql_paged_result($sql, $dbconn);
	if( $result = $qp->fetch_page(1) )
	{
		print_r($qp->fetch_stats);
	}
	else
	{
		print_r($qp->debug());
		print_r($qp->error());
		exit();
	}
	*/
?>