<?php

$DB_NAME = 'reserve';
$DB_HOST = 'mysql';
$DB_USER = 'root';
$DB_PASS = 'F7m9dSz0';

$linkID = new mysqli($DB_HOST, $DB_USER, $DB_PASS, $DB_NAME);

if (mysqli_connect_errno()) {
   printf("Connect failed: %s\n", mysqli_connect_error());
   exit();
}


   // Begin security
   $ip_array[] = "4.26.210.66";
   $ip_array[] = "98.142.222.58";
	$ip_array[] = "98.142.222.62";
   $ip_array[] = "24.145.40.252";
   $ip_array[] = "50.193.242.185";
   $ip_array[] = "50.193.242.186";
   $ip_array[] = "50.193.242.188";
   $ip_array[] = "";
   $get_ip = $_SERVER['REMOTE_ADDR'];
   foreach ($ip_array as $value) {
      if ($value == $get_ip) {
         $secure = "1";
      }
   }
   if ($secure != "1") {
      print "<font color=red>SCRIPT ERROR!</font>\n";
      die;
   }
   // End security


class Yacht {
	// Begin Class
	public $linkID;

   function __construct($linkID){ $this->linkID = $linkID; }

   public function new_mysql($sql) {
		$result = $this->linkID->query($sql) or die($this->linkID->error.__LINE__);
		return $result;
	}

	/*
	Determins the current and past charterID
	*/
	public function get_current_charter($boatID) {

		switch ($boatID) {
			case "10":
			$day_range = "10";
			break;

			default:
			$day_range = "5";
			break;
		}

		// Generate Date Range
		$today = date("Ymd");
		$range1a = strtotime($today);
		$range1a = strtotime("-$day_range day", $range1a);
		$range1 = date("Ymd", $range1a);

      $range2a = strtotime($today);
      $range2a = strtotime("+$day_range day", $range2a);
      $range2 = date("Ymd", $range2a);

		$year_range1 = 365 + $day_range;
		$year_range2 = 265 - $day_range;

      $range3a = strtotime($today);
      $range3a = strtotime("-$year_range1 day", $range3a);
      $range3 = date("Ymd", $range3a);

      $range4a = strtotime($today);
      $range4a = strtotime("-$year_range2 day", $range4a);
      $range4 = date("Ymd", $range4a);
		// End Date Range

		// Build Data
		$name = $this->GetName($boatID);
		if ($name == "Galapagos Aggressor I") {
			$name = "Galapagos Aggressor I & II";
		}

		$charter_current = $this->GetCharterID($boatID,$range1,$range2);

		if ($boatID == "7") {
			$charter_past = $this->GetCharterID('8',$range3,$range4);
		} else {
			$charter_past = $this->GetCharterID($boatID,$range3,$range4);
		}

		$date_current = $this->CharterDate($charter_current);
		$date_past = $this->CharterDate($charter_past);

		if ($date_current == "") {
			$date_current = "None";
		}
		if ($date_past == "") {
			$date_past = "None";
		}

		$sales_current = $this->GetCharterSales($charter_current);
		$sales_past = $this->GetCharterSales($charter_past);
		$sales_diff = $this->diff_per ($sales_past,$sales_current);

		$guest_current = $this->GetGuests($charter_current);
		$guest_past = $this->GetGuests($charter_past);
		if ($guest_current[0] == "") {
			$guest_current[0] = "0";
		}
		if ($guest_current[1] == "") {
			$guest_current[1] = "0";
		}
		if ($guest_past[0] == "") {
			$guest_past[0] = "0";
		}
		if ($guest_past[1] == "") {
			$guest_past[1] = "0";
		}
		$guest_diff = $this->diff_per($guest_past[1],$guest_current[1]);
		// End Data Build

		// Build the array
		$data = array();
		$data[0] = $name;
		$data[1] = $date_current;
		$data[2] = $date_past;
		$data[3] = $sales_current;
		$data[4] = $sales_past;
		$data[5] = $sales_diff;
		$data[6] = $guest_current[0];
		$data[7] = $guest_current[1];
		$data[8] = $guest_past[0];
		$data[9] = $guest_past[1];
		$data[10] = $guest_diff;
		$data[11] = $charter_current;
		$data[12] = $charter_past;

		return $data;
		// Test back to screen
		// print "Test Data for $name\n\n
		// Current: $charter_current ($date_current) : $ $sales_current\n
		// Past: $charter_past ($date_past) : $ $sales_past\n";
	}

	public function GetGuests($charterID) {
		if ($charterID != "") {
			$sql = "
			SELECT
				COUNT(`inventory`.`inventoryID`) AS 'total'

			FROM
				`inventory`

			WHERE
				`inventory`.`charterID` = '$charterID'

			GROUP BY `inventory`.`charterID`
			";
			$result = $this->new_mysql($sql);
			while ($row = $result->fetch_assoc()) {
				$total = $row['total'];
			}

	      $sql = "
   	   SELECT
      	   COUNT(`inventory`.`inventoryID`) AS 'total'

	      FROM
   	      `inventory`

      	WHERE
         	`inventory`.`charterID` = '$charterID'
				AND `inventory`.`status` IN ('booked','tentative')

			GROUP BY `inventory`.`charterID`
      	";
	      $result = $this->new_mysql($sql);
   	   while ($row = $result->fetch_assoc()) {
      	   $booked = $row['total'];
	      }
			$data = array();
			$data[0] = $total;
			$data[1] = $booked;
			return $data;
		}
	}

	public function diff_per ($prev_year,$this_year) {
	   if ($prev_year == "") {
   	   $prev_year = "0";
	   }
   	if ($this_year == "") {
      	$this_year = "0";
	   }

   	if ($this_year < $prev_year) {
      	// Reduction
	      $diff = (($prev_year - $this_year) / $prev_year) * 100;
   	   $diff = $diff * -1;
	   } else {
   	   // increase
      	@$diff = (($this_year - $prev_year) / $this_year) * 100;
	   }  
   	return $diff;
	}     


	/*
	Returns only 1 charter ID for the boat and date range specified
	*/
	public function GetCharterID($boatID,$range1,$range2) {
      $sql = "
      SELECT
         `charters`.`charterID`

      FROM
         `charters`

      WHERE
         `charters`.`boatID` = '$boatID'
         AND `charters`.`start_date` BETWEEN '$range1' AND '$range2'

      ORDER BY `charters`.`start_date` ASC

      LIMIT 1
      ";

      $result = $this->new_mysql($sql);
      while ($row = $result->fetch_assoc()) {
         $charterID = $row['charterID'];
      }
		return $charterID;
	}

	/*
	Returns the total sale amount of the selected charter
	*/
	public function GetCharterSales($charterID) {
		$sql = "
		SELECT
      	SUM(`inventory`.`bunk_price`+`charters`.`add_on_price_commissionable`) AS 'total'

		FROM
      	`inventory`,`charters`

      WHERE
         `inventory`.`charterID` = '$charterID'
         AND `inventory`.`status` IN ('booked','tentative')
         AND `inventory`.`charterID` = `charters`.`charterID`
      ";
		$result = $this->new_mysql($sql);
		while ($row = $result->fetch_assoc()) {
			$sales = $row['total'];
		}
		return $sales;
	}

	/*
	Returns the date of the charter
	*/
	public function CharterDate($charterID) {
		$sql = "SELECT DATE_FORMAT(`charters`.`start_date`, '%b %d, %Y') AS 'start_date' FROM `charters`  WHERE `charters`.`charterID` = '$charterID'";
		$result = $this->new_mysql($sql);
		while ($row = $result->fetch_assoc()) {
			return $row['start_date'];
		}
	}

	/*
	Returns boat name
	*/
	public function GetName($boatID) {
		$sql = "SELECT `boats`.`name` FROM `boats` WHERE `boatID` = '$boatID'";
      $result = $this->new_mysql($sql);
      while ($row = $result->fetch_assoc()) {
			return $row['name'];
		}
	}

	public function ytd($boatID,$current_charter,$past_charter) {
		// current
		$current = $this->get_year($current_charter);
		$range1 = $current[0] . "0101";
		$range2 = $current[0] . $current[1] . $current[2];
		$current_sales = $this->GetYTDCharterSales($boatID,$range1,$range2);
		$current_guests = $this->GetYTDGuests($boatID,$range1,$range2);
      $updown1 = $this->GetUpDown($boatID,$range1,$range2);

		// past
		$past = $this->get_year($past_charter);
		$range1 = $past[0] . "0101";
		$range2 = $past[0] . $past[1] . $past[2];
		$past_sales = $this->GetYTDCharterSales($boatID,$range1,$range2);
		$past_guests = $this->GetYTDGuests($boatID,$range1,$range2);
      $updown2 = $this->GetUpDown($boatID,$range1,$range2);

      $sales_diff = $this->diff_per($past_sales,$current_sales);
		$guest_diff = $this->diff_per($past_guests[1],$current_guests[1]);


		$data = array();
		$data[0] = $current[0];
		$data[1] = $past[0];
		$data[2] = $current_sales;
		$data[3] = $past_sales;

		$data[5] = $sales_diff;
		$data[6] = $current_guests[0];
		if ($data[6] == "") { $data[6] = "0"; }
		$data[7] = $current_guests[1];
		if ($data[7] == "") { $data[7] = "0"; }
		$data[8] = $past_guests[0];
		if ($data[8] == "") { $data[8] = "0"; }
		$data[9] = $past_guests[1];
		if ($data[9] == "") { $data[9] = "0"; }
		$data[10] = $guest_diff;
		$data[11] = $updown1[0]; // down
		$data[12] = $updown1[1]; // up
      $data[13] = $updown2[0]; // down
      $data[14] = $updown2[1]; // up

		return $data;

	}

   public function rollingytd($boatID,$current_charter,$past_charter) {
      // current
      $current = $this->get_year($current_charter);
      $range1 = $current[0] . "0101";
      $range2 = $current[0] . "1231";
      $current_sales = $this->GetYTDCharterSales($boatID,$range1,$range2);
      $current_guests = $this->GetYTDGuests($boatID,$range1,$range2);
      $updown1 = $this->GetUpDown($boatID,$range1,$range2);

      // past
      $past = $this->get_year($past_charter);
      $range1 = $past[0] . "0101";
      $range2 = $past[0] . "1231";
      $past_sales = $this->GetYTDCharterSales($boatID,$range1,$range2);
      $past_guests = $this->GetYTDGuests($boatID,$range1,$range2);
      $updown2 = $this->GetUpDown($boatID,$range1,$range2);

      $sales_diff = $this->diff_per($past_sales,$current_sales);
      $guest_diff = $this->diff_per($past_guests[1],$current_guests[1]);


      $data = array();
      $data[0] = $current[0];
      $data[1] = $past[0];
      $data[2] = $current_sales;
      $data[3] = $past_sales;

      $data[5] = $sales_diff;
      $data[6] = $current_guests[0];
      if ($data[6] == "") { $data[6] = "0"; }
      $data[7] = $current_guests[1];
      if ($data[7] == "") { $data[7] = "0"; }
      $data[8] = $past_guests[0];
      if ($data[8] == "") { $data[8] = "0"; }
      $data[9] = $past_guests[1];
      if ($data[9] == "") { $data[9] = "0"; }
      $data[10] = $guest_diff;
      $data[11] = $updown1[0]; // down
      $data[12] = $updown1[1]; // up
      $data[13] = $updown2[0]; // down
      $data[14] = $updown2[1]; // up

      return $data;

   }



   public function GetYTDCharterSales($boatID,$range1,$range2) {
		if ($boatID == "7") {
			$boat_sql = "`charters`.`boatID` IN ('7','8')";
		} else {
			$boat_sql = "`charters`.`boatID` = '$boatID'";
		}
      $sql = "
      SELECT
         SUM(`inventory`.`bunk_price`+`charters`.`add_on_price_commissionable`) AS 'total'

      FROM
         `inventory`,`charters`

      WHERE
			#`charters`.`boatID` = '$boatID'
			$boat_sql
			AND `charters`.`start_date` BETWEEN '$range1' AND '$range2'
			AND `charters`.`charterID` = `inventory`.`charterID`
         AND `inventory`.`status` IN ('booked','tentative')
         AND `inventory`.`charterID` = `charters`.`charterID`
      ";

      $result = $this->new_mysql($sql);
      while ($row = $result->fetch_assoc()) {
         $sales = $row['total'];
      }
      return $sales;
   }

   public function GetYTDGuests($boat,$range1,$range2) {
      if ($boat != "") {

	      if ($boat == "7") {
   	      $boat_sql = "`charters`.`boatID` IN ('7','8')";
      	} else {
         	$boat_sql = "`charters`.`boatID` = '$boat'";
	      }


         $sql = "
         SELECT
            COUNT(`inventory`.`inventoryID`) AS 'total'

         FROM
            `inventory`,`charters`

         WHERE
				#`charters`.`boatID` = '$boat'
				$boat_sql
				AND `charters`.`start_date` BETWEEN '$range1' AND '$range2'
				AND `charters`.`charterID` = `inventory`.`charterID`

         GROUP BY `charters`.`boatID`
         ";

         $result = $this->new_mysql($sql);
         while ($row = $result->fetch_assoc()) {
            $total = $row['total'];
         }

         $sql = "
         SELECT
            COUNT(`inventory`.`inventoryID`) AS 'total'

         FROM
            `inventory`,`charters`

         WHERE
				`charters`.`boatID` = '$boat'
				AND `charters`.`start_date` BETWEEN '$range1' AND '$range2'
				AND `charters`.`charterID` = `inventory`.`charterID`
            AND `inventory`.`status` IN ('booked','tentative')

         GROUP BY `charters`.`boatID`
         ";
         $result = $this->new_mysql($sql);
         while ($row = $result->fetch_assoc()) {
            $booked = $row['total'];
         }
         $data = array();
         $data[0] = $total;
         $data[1] = $booked;
         return $data;
      }
   }


	public function get_year($charterID) {
		if ($charterID != "") {
			$sql = "
			SELECT
				DATE_FORMAT(`charters`.`start_date`, '%d') AS 'day',
				DATE_FORMAT(`charters`.`start_date`, '%m') AS 'month',
				DATE_FORMAT(`charters`.`start_date`, '%Y') AS 'year'

			FROM
				`charters`

			WHERE
				`charters`.`charterID` = '$charterID'
			";

			$result = $this->new_mysql($sql);
			$date = array();
			while ($row = $result->fetch_assoc()) {
				$date[0] = $row['year'];
				$date[1] = $row['month'];
				$date[2] = $row['day'];
			}
			return $date;
		}
	}

	public function GetUpDown($boatID,$range1,$range2) {
      if ($boatID == "7") {
         $boat_sql = "`charters`.`boatID` IN ('7','8')";
      } else {
         $boat_sql = "`charters`.`boatID` = '$boatID'";
      }
		$sql = "
		SELECT
			`charters`.`statusID`

		FROM
			`charters`

		WHERE
			#`charters`.`boatID` = '$boatID'
			$boat_sql
			AND `charters`.`start_date` BETWEEN '$range1' AND '$range2'

		";
		$down = "0";
		$up = "0";
		$result = $this->new_mysql($sql);
		while ($row = $result->fetch_assoc()) {
			if ($row['statusID'] == "7") {
				$down++;
			} else {
				$up++;
			}
		}
		$data = array();
		$data[0] = $down;
		$data[1] = $up;
		return $data;
	}

	/* Displays the future bookings */
	public function future($boat,$year,$week1,$week2,$extra) {

		if ($extra == "") {
		   $boat_sql = "AND c.`boatID` = '$boat'";
		} else {
			$boat_sql = "AND c.`boatID` IN ($extra)";
		}

	   $month = date("m");
   	$day = date("d");

	   //$date1 = $year.$month.$day;
   	$date1 = date("Ymd", strtotime("$day.$month.$year - 1 weeks"));
	   $date2 = date("Ymd", strtotime("$day.$month.$year + $week2 weeks"));

   	//print "T: $date1 to $date2<br>\n";
	   $sql = "
   	SELECT
		   c.charterID,
		   c.start_date,
		   DATE_FORMAT(c.start_date,'%d %M %Y') AS 'charter_date',
		   c.boatID,
		   #c.add_on_price_commissionable,
		   #c.add_on_price,
		   #c.capacity,
		   #statuses.name,
		   #statuses.status,
		   SUM(IF(INV1.status='booked',1,0)) AS 'total_booked',
		   SUM(IF(INV1.status='tentative',1,0)) AS 'total_tentative',
		   COUNT(INV1.status) AS 'total_compacity'

		   FROM `charters` c, `statuses`
		   LEFT JOIN inventory AS INV1 ON c.charterID = INV1.charterID

		   WHERE c.start_date BETWEEN '$date1' AND '$date2'
			   #AND c.`boatID` IN ('1','3','7','8','9','10','11','16','21','24')
			   $boat_sql
			   AND c.`statusID` = `statuses`.`statusID`
			   AND c.`statusID` NOT IN ('7')
		   AND c.`nights` > 0

		   GROUP BY INV1.charterID

	   ORDER BY c.`start_date` ASC
	   ";

		$result = $this->new_mysql($sql);
		while ($row = $result->fetch_assoc()) {
	      $booked = $booked + $row['total_booked'];
   	   $tentative = $tentative + $row['total_tentative'];
      	$comp = $comp + $row['total_compacity'];
	   }
	   @$per_booked = $booked / $comp;
   	$per_booked = $per_booked * 100;

	   @$per_ten = $tentative / $comp;
   	$per_ten = $per_ten * 100;

	   $total = $booked + $tentative;
   	@$per_total = $total / $comp;
	   $per_total = $per_total * 100;

	   $data = array();
   	$data[0] = $per_booked;
	   $data[1] = $per_ten;
   	$data[2] = $per_total;
	   return $data;
	}


	// End Class
}



// Execute Program
$Yacht = new Yacht($linkID);

$date_time = date("M d, Y - h:i A");
$html = "<h2>AF/DF Yacht Report - Totals ($date_time)</h2><hr>";

// Get boats in order
$sql = "
SELECT
	`boats`.`boatID`

FROM
	`boats`

WHERE
	`boats`.`Status` = 'Active'

ORDER BY `boats`.`name` ASC

";
$boats = array();
$result = $Yacht->new_mysql($sql);
while ($row = $result->fetch_assoc()) {
	$boats[] = $row['boatID'];
	$boats_in .= "'$row[boatID]',";
}
$boats_in = substr($boats_in, 0, -1);
//$boats = array('1','3','7','9','10','11','16','21','27','28','29','30','31','32','33','34');
foreach ($boats as $boat) {
	// Returns sales single charter
	$area1 = $Yacht->get_current_charter($boat);

	$area1T[3] = $area1T[3] + $area1[3];
	$area1T[4] = $area1T[4] + $area1[4];
	$area1T[6] = $area1T[6] + $area1[6];
	$area1T[7] = $area1T[7] + $area1[7];
   $area1T[8] = $area1T[8] + $area1[8];
   $area1T[9] = $area1T[9] + $area1[9];

	// YTD
	$area2 = $Yacht->ytd($boat,$area1[11],$area1[12]);

	$area2T[2] = $area2T[2] + $area2[2];
	$area2T[3] = $area2T[3] + $area2[3];
   $area2T[6] = $area2T[6] + $area2[6];
   $area2T[7] = $area2T[7] + $area2[7];
   $area2T[8] = $area2T[8] + $area2[8];
   $area2T[9] = $area2T[9] + $area2[9];

	$area2T[11] = $area2T[11] + $area2[11];
   $area2T[12] = $area2T[12] + $area2[12];
   $area2T[13] = $area2T[13] + $area2[13];
   $area2T[14] = $area2T[14] + $area2[14];

	@$per_guest1 = ($area2[9] / $area2[8]) * 100;
	@$per_guest2 = ($area2[7] / $area2[6]) * 100;

	$per_guest_diff = $Yacht->diff_per($per_guest1,$per_guest2);

	@$dpg1 = $area2[3] / $area2[9];
	@$dpg2 = $area2[2] / $area2[7];
	$dpgd = $Yacht->diff_per($dpg1,$dpg2);

	// Rolling YTD
	// Specify charter for RSA
	if (($area1[11] == "") && ($boat == "34")) {
		$area1[11] = "80607";
	}

   $area3 = $Yacht->rollingytd($boat,$area1[11],$area1[12]);
   $area3T[2] = $area3T[2] + $area3[2];
   $area3T[3] = $area3T[3] + $area3[3];
   $area3T[6] = $area3T[6] + $area3[6];
   $area3T[7] = $area3T[7] + $area3[7];
   $area3T[8] = $area3T[8] + $area3[8];
   $area3T[9] = $area3T[9] + $area3[9];

   $area3T[11] = $area3T[11] + $area3[11];
   $area3T[12] = $area3T[12] + $area3[12];
   $area3T[13] = $area3T[13] + $area3[13];
   $area3T[14] = $area3T[14] + $area3[14];

   @$rper_guest1 = ($area3[9] / $area3[8]) * 100;
   @$rper_guest2 = ($area3[7] / $area3[6]) * 100;

   $rper_guest_diff = $Yacht->diff_per($rper_guest1,$rper_guest2);

   @$rdpg1 = $area3[3] / $area3[9];
   @$rdpg2 = $area3[2] / $area3[7];
   $rdpgd = $Yacht->diff_per($rdpg1,$rdpg2);

	// Future
	$extra = "";
   $f_year = date("Y");
   $future_4 = $Yacht->future($boat,$f_year,"0","4",$extra);
   $future_13 = $Yacht->future($boat,$f_year,"5","13",$extra);
   $future_26 = $Yacht->future($boat,$f_year,"14","26",$extra);
   $future_39 = $Yacht->future($boat,$f_year,"27","39",$extra);
   $future_52 = $Yacht->future($boat,$f_year,"40","52",$extra);
   $future_65 = $Yacht->future($boat,$f_year,"53","65",$extra);
   $future_78 = $Yacht->future($boat,$f_year,"66","78",$extra);


	// Build table
	$html .= "<b>$area1[0]</b><br>
	<table border=0 width=100%>
		<tr>
			<td width=25% valign=top>
				<table border=1 width=100%>
				<tr><td colspan=4 align=center><b>CURRENT CHARTER TOTALS</b></td></tr>
				<tr><td width=70>Charter</td><td width=100>$area1[2]</td><td width=100>$area1[1]</td><td width=40>+-</td></tr>
				<tr><td><b>SALES</b></td><td>$".number_format($area1[4],2)."</td><td>$".number_format($area1[3],2)."</td><td>".floor($area1[5])."%</td></tr>
				<tr><td><b>GUEST</b></td><td>  $area1[9]/$area1[8]  </td><td>  $area1[7]/$area1[6]  </td><td>".floor($area1[10])."%</td></tr>
				</table>
			</td>
         <td width=25% valign=top>
            <table border=1 width=100%>
            <tr><td colspan=4 align=center><b>$area2[1] - YTD TOTALS - $area2[0]</b></td></tr>
            <tr><td width=70>Thru</td><td width=100>($area1[2])</td><td width=100>($area1[1])</td><td width=40>+-</td></tr>
            <tr><td><b>SALES</b></td><td>$".number_format($area2[3],2)."</td><td>$".number_format($area2[2],2)."</td><td>".floor($area2[5])."%</td></tr>
            <tr><td><b>GUEST</b></td><td>  $area2[9]/$area2[8]  </td><td>  $area2[7]/$area2[6]  </td><td>".floor($area2[10])."%</td></tr>
				<tr><td><b>GUEST %</b></td><td>".floor($per_guest1)."</td><td>".floor($per_guest2)."</td><td>".floor($per_guest_diff)."%</td></tr>
				<tr><td><b>$/GUEST</b></td><td>$".number_format($dpg1,2)."</td><td>$".number_format($dpg2,2)."</td><td>".floor($dpgd)."%</td></tr>
				<tr><td><b>UP/DOWN</b></td><td>$area2[12]/$area2[11]</td><td>$area2[14]/$area2[13]</td><td></td>  </tr>
				</table>
			</td>
         <td width=25% valign=top>
            <table border=1 width=100%>
            <tr><td colspan=4 align=center><b>CALENDAR YEAR TOTALS</b></td></tr>
            <tr><td width=70>Thru</td><td width=100>($area3[1])</td><td width=100>($area3[0])</td><td width=40>+-</td></tr>
            <tr><td><b>SALES</b></td><td>$".number_format($area3[3],2)."</td><td>$".number_format($area3[2],2)."</td><td>".floor($area3[5])."%</td></tr>
            <tr><td><b>GUEST</b></td><td>  $area3[9]/$area3[8]  </td><td>  $area3[7]/$area3[6]  </td><td>".floor($area3[10])."%</td></tr>
            <tr><td><b>GUEST %</b></td><td>".floor($rper_guest1)."</td><td>".floor($rper_guest2)."</td><td>".floor($rper_guest_diff)."%</td></tr>
            <tr><td><b>$/GUEST</b></td><td>$".number_format($rdpg1,2)."</td><td>$".number_format($rdpg2,2)."</td><td>".floor($rdpgd)."%</td></tr>
            <tr><td><b>UP/DOWN</b></td><td>$area3[12]/$area3[11]</td><td>$area3[14]/$area3[13]</td><td></td>  </tr>


            </table>
         </td>
         <td width=25% valign=top>
            <table border=1 width=100%>
            <tr><td colspan=4 align=center><b>FUTURE TOTAL</b></td></tr>
            <tr><td width=70># of weeks</td><td width=70>Conf</td><td width=70>Tent</td><td>Total</td></tr>
            <tr><td width=25%>4</td><td width=25%>".number_format($future_4[0],0)."%</td><td width=25%>".number_format($future_4[1],0)."%</td><td width=25%>".floor($future_4[2])."%</td></tr>
            <tr><td>13</td><td>".number_format($future_13[0],0)."%</td><td>".number_format($future_13[1],0)."%</td><td>".floor($future_13[2])."%</td></tr>
            <tr><td>26</td><td>".number_format($future_26[0],0)."%</td><td>".number_format($future_26[1],0)."%</td><td>".floor($future_26[2])."%</td></tr>
            <tr><td>39</td><td>".number_format($future_39[0],0)."%</td><td>".number_format($future_39[1],0)."%</td><td>".floor($future_39[2])."%</td></tr>
            <tr><td>52</td><td>".number_format($future_52[0],0)."%</td><td>".number_format($future_52[1],0)."%</td><td>".floor($future_52[2])."%</td></tr>
            <tr><td>65</td><td>".number_format($future_65[0],0)."%</td><td>".number_format($future_65[1],0)."%</td><td>".floor($future_65[2])."%</td></tr>
            <tr><td>78</td><td>".number_format($future_78[0],0)."%</td><td>".number_format($future_78[1],0)."%</td><td>".floor($future_78[2])."%</td></tr>

            </table>
         </td>
		</tr>
	</table>
	<br>";

}

// Display totals

	$area1T[5] = $Yacht->diff_per($area1T[4],$area1T[3]);
	$area1T[10] = $Yacht->diff_per($area1T[9],$area1T[7]);
	$area2T[5] = $Yacht->diff_per($area2T[3],$area2T[2]);
	$area2T[10] = $Yacht->diff_per($area2T[9],$area2T[7]);
   $area3T[5] = $Yacht->diff_per($area3T[3],$area3T[2]);
   $area3T[10] = $Yacht->diff_per($area3T[9],$area3T[7]);

   @$per_guest1 = ($area2T[9] / $area2T[8]) * 100;
   @$per_guest2 = ($area2T[7] / $area2T[6]) * 100;

   $per_guest_diff = $Yacht->diff_per($per_guest1,$per_guest2);

   @$dpg1 = $area2T[3] / $area2T[9];
   @$dpg2 = $area2T[2] / $area2T[7];
   $dpgd = $Yacht->diff_per($dpg1,$dpg2);



   @$rper_guest1 = ($area3T[9] / $area3T[8]) * 100;
   @$rper_guest2 = ($area3T[7] / $area3T[6]) * 100;

   $rper_guest_diff = $Yacht->diff_per($rper_guest1,$rper_guest2);

   @$rdpg1 = $area3T[3] / $area3T[9];
   @$rdpg2 = $area3T[2] / $area3T[7];
   $rdpgd = $Yacht->diff_per($rdpg1,$rdpg2);

   // Future
   $f_year = date("Y");
   $future_4 = $Yacht->future($boat,$f_year,"0","4",$boats_in);
   $future_13 = $Yacht->future($boat,$f_year,"5","13",$boats_in);
   $future_26 = $Yacht->future($boat,$f_year,"14","26",$boats_in);
   $future_39 = $Yacht->future($boat,$f_year,"27","39",$boats_in);
   $future_52 = $Yacht->future($boat,$f_year,"40","52",$boats_in);
   $future_65 = $Yacht->future($boat,$f_year,"53","65",$boats_in);
   $future_78 = $Yacht->future($boat,$f_year,"66","78",$boats_in);

   $html .= "<b>TOTAL</b><br>
   <table border=0 width=100%>
      <tr>
         <td width=25% valign=top>
            <table border=1 width=100%>
            <tr><td colspan=4 align=center><b>CURRENT CHARTER TOTALS</b></td></tr>
            <tr><td width=70>Charter</td><td width=100><b>Past</b></td><td width=100><b>Current</b></td><td width=40>+-</td></tr>
            <tr><td><b>SALES</b></td><td>$".number_format($area1T[4],2)."</td><td>$".number_format($area1T[3],2)."</td><td>".floor($area1T[5])."%</td></tr>
            <tr><td><b>GUEST</b></td><td>  $area1T[9]/$area1T[8]  </td><td>  $area1T[7]/$area1T[6]  </td><td>".floor($area1T[10])."%</td></tr>
            </table>
         </td>
         <td width=25% valign=top>
            <table border=1 width=100%>
            <tr><td colspan=4 align=center><b>YTD TOTALS</b></td></tr>
            <tr><td width=70>Thru</td><td width=100><b>Past</b></td><td width=100><b>Current</b></td><td width=40>+-</td></tr>
            <tr><td><b>SALES</b></td><td>$".number_format($area2T[3],2)."</td><td>$".number_format($area2T[2],2)."</td><td>".floor($area2T[5])."%</td></tr>
            <tr><td><b>GUEST</b></td><td>  $area2T[9]/$area2T[8]  </td><td>  $area2T[7]/$area2T[6]  </td><td>".floor($area2T[10])."%</td></tr>
            <tr><td><b>GUEST %</b></td><td>".floor($per_guest1)."</td><td>".floor($per_guest2)."</td><td>".floor($per_guest_diff)."%</td></tr>
            <tr><td><b>$/GUEST</b></td><td>$".number_format($dpg1,2)."</td><td>$".number_format($dpg2,2)."</td><td>".floor($dpgd)."%</td></tr>
            <tr><td><b>UP/DOWN</b></td><td>$area2T[12]/$area2T[11]</td><td>$area2T[14]/$area2T[13]</td><td></td>  </tr>


            </table>
         </td>
         <td width=25% valign=top>
            <table border=1 width=100%>
            <tr><td colspan=4 align=center><b>CALENDAR YEAR TOTALS</b></td></tr>
            <tr><td width=70>Thru</td><td width=100><b>Past</b></td><td width=100><b>Current</b></td><td width=40>+-</td></tr>
            <tr><td><b>SALES</b></td><td>$".number_format($area3T[3],2)."</td><td>$".number_format($area3T[2],2)."</td><td>".floor($area3T[5])."%</td></tr>
            <tr><td><b>GUEST</b></td><td>  $area3T[9]/$area3T[8]  </td><td>  $area2T[7]/$area3T[6]  </td><td>".floor($area3T[10])."%</td></tr>
            <tr><td><b>GUEST %</b></td><td>".floor($rper_guest1)."</td><td>".floor($rper_guest2)."</td><td>".floor($rper_guest_diff)."%</td></tr>
            <tr><td><b>$/GUEST</b></td><td>$".number_format($rdpg1,2)."</td><td>$".number_format($rdpg2,2)."</td><td>".floor($rdpgd)."%</td></tr>
            <tr><td><b>UP/DOWN</b></td><td>$area3T[12]/$area3T[11]</td><td>$area3T[14]/$area3T[13]</td><td></td>  </tr>


            </table>
         </td>
         <td width=25% valign=top>
            <table border=1 width=100%>
            <tr><td colspan=4 align=center><b>FUTURE TOTAL</b></td></tr>
            <tr><td width=25%>4</td><td width=25%>".number_format($future_4[0],0)."%</td><td width=25%>".number_format($future_4[1],0)."%</td><td width=25%>".floor($future_4[2])."%</td></tr>
            <tr><td>13</td><td>".number_format($future_13[0],0)."%</td><td>".number_format($future_13[1],0)."%</td><td>".floor($future_13[2])."%</td></tr>
            <tr><td>26</td><td>".number_format($future_26[0],0)."%</td><td>".number_format($future_26[1],0)."%</td><td>".floor($future_26[2])."%</td></tr>
            <tr><td>39</td><td>".number_format($future_39[0],0)."%</td><td>".number_format($future_39[1],0)."%</td><td>".floor($future_39[2])."%</td></tr>
            <tr><td>52</td><td>".number_format($future_52[0],0)."%</td><td>".number_format($future_52[1],0)."%</td><td>".floor($future_52[2])."%</td></tr>
            <tr><td>65</td><td>".number_format($future_65[0],0)."%</td><td>".number_format($future_65[1],0)."%</td><td>".floor($future_65[2])."%</td></tr>
            <tr><td>78</td><td>".number_format($future_78[0],0)."%</td><td>".number_format($future_78[1],0)."%</td><td>".floor($future_78[2])."%</td></tr>


            </table>
         </td>
      </tr>
   </table>
   <br>";


   $subject = "AF/DF Yacht Report - Totals (Version 3)";

   // email headers - This is fine tuned, please do not modify
   $header2 = "MIME-Version: 1.0\r\n";
   $header2 .= "Content-type: text/html; charset=iso-8859-1\r\n";
   $header2 .= "From: AF/DF Reports <info@aggressor.com>\r\n";
   $header2 .= "Reply-To: AF/DF Reports <info@aggressor.com>\r\n";
   $header2 .= "X-Priority: 3\r\n";
   $header2 .= "X-Mailer: PHP/" . phpversion()."\r\n";
   //mail("anne@aggressor.com, wayne@wayneworks.com, wayne@aggressor.com, larry@dancerfleet.com, tom@liveaboardfleet.com, robert@wayneworks.com",$subject,$html,$header2);
   //mail("robert@wayneworks.com", $subject,$html,$header2);

	print "$html";

?>
